#include "AD18F08.h"
#include <stdio.h>
#include "common.h"

/*******************************************************************************
// ----Function: GPIO_Init
// --Parameters: 
// -----Returns: None   
//---------Note:所有IO初始化
*******************************************************************************/

void GPIO_Init(void)
{
	TRISA = 0X00;   //PA输出模式
	TRISB = 0X00;   //PB输出模式
	
	PORTA = 0X00;	//PORTA输出0
	PORTB = 0X00;	//PORTB输出0
	
	PAPD = 0XFF;    //关闭PA下拉
	PAPU = 0XFF;    //关闭PA上拉
	PBPD = 0XFF;    //关闭PB下拉
	PBPU = 0XFF;    //关闭PB上拉
	
	PAOD = 0X00;    //关PA开漏输出
	PBOD = 0X00;    //关PB开漏输出
	
	ANASEL0 = 0X00; //关PA模拟量通道
	ANASEL1 = 0X00; //关PB模拟量通道
}



void Timer1_edge_io(void)
{
	TRISB6 = 1;    //设置PB6的方向为输入
	TRISB7 = 1;    //设置PB7的方向为输入
	TRISA4 = 1;    //设置PA4的方向为输入

	TMR1H  = 0X00;
	TMR1L  = 0X00;
	T1CON0 = 0X25;  // 4分频   16M   使能timer1
	T1CON1 = 0X11;  //上升沿开始，下降沿结束，模式1  测量通道（PB6作为检测）
    //T1CON1 = 0X01;  //下降沿开始，上升沿结束，模式1  测量通道（PB6作为检测）
	//T1CON1 = 0X15;  //上升沿开始，下降沿结束，模式1  测量通道（PB7作为检测）
	//T1CON1 = 0X05;  //下降沿开始，上升沿结束，模式1  测量通道（PB7作为检测）
	//T1CON1 = 0X19;  //上升沿开始，下降沿结束，模式1  测量通道（PA4作为检测）
	//T1CON1 = 0X09;  //下降沿开始，上升沿结束，模式1  测量通道（PA4作为检测）
	TMR1IF = 0;      //清中断标志
	TMR1IP = 1;		 //高优先级中断
	TMR1IE = 1;      //使能TMR1中断
	INT2IF = 0;      //清中断标志
	INT2IP = 1;      //高优先级中断
	INT2IE = 1;	     //使能外部中断
}
void Timer1_edge_io_mode1(void)
{
	TRISB6 = 1;       //设置PB6的方向为输入
	TRISB7 = 1;       //设置PB7的方向为输入
	TRISA4 = 1;       //设置PA4的方向为输入

	TMR1H  = 0X00;
	TMR1L  = 0X00;
	T1CON0 = 0X25;  // 4分频   16M   使能timer1
	//T1CON1 = 0X12;  //上升沿开始，下降沿结束，模式1  测量通道（PB6作为检测）
    //T1CON1 = 0X02;  //下降沿开始，上升沿结束，模式1  测量通道（PB6作为检测）
    //T1CON1 = 0X06;  //下降沿开始，上升沿结束，模式1  测量通道（PB7作为检测）
    //T1CON1 = 0X16;  //上升沿开始，下降沿结束，模式1  测量通道（PB7作为检测）
    //T1CON1 = 0X0a;  //下降沿开始，上升沿结束，模式1  测量通道（PA4作为检测）
    T1CON1 = 0X1a;  //上升沿开始，下降沿结束，模式1  测量通道（PA4作为检测）
	TMR1IF = 0;      //清中断标志
	TMR1IP = 1;		 //高优先级中断
	TMR1IE = 1;      //开TMR1中断
	INT2IF = 0;
	INT2IP = 1;
	INT2IE = 1;	
}
void Timer1_edge(void)
{
	TMR1H  = 0X00;
	TMR1L  = 0X00;
	T1CON0 = 0X25;  // 4分频   16M   使能timer1
	T1CON1 = 0X1D;  //上升沿开始，下降沿结束，模式0  测量通道（TMR2CLK作为脉宽检测输入信号）
   // T1CON1 = 0X0D;  //下降沿开始，上升沿结束，模式0  测量通道（TMR2CLK作为脉宽检测输入信号）
	TMR1IF = 0;      //清中断标志
	TMR1IP = 1;		 //高优先级中断
	TMR1IE = 1;      //使能TMR1中断
	INT2IF = 0;      //清中断标志
	INT2IP = 1;      //高优先级中断
	INT2IE = 1;      //使能外部中断

	PR2H = 0X03;     //500us
	PR2L = 0XE8;
	TMR1H  = 0X00;
	TMR1L  = 0X00;
	T2CON = 0X06;    //使能TMR2 预分频设置为8分频
	
}
void Timer1_edge_mode1(void)
{
	TMR1H  = 0X00;
	TMR1L  = 0X00;
	T1CON0 = 0X25;  // 4分频   16M   使能timer1
	T1CON1 = 0X1E;  //上升沿开始，下降沿结束，模式1  测量通道（TMR2CLK作为脉宽检测输入信号）
   // T1CON1 = 0X0E;  //下降沿开始，上升沿结束，模式1  测量通道（TMR2CLK作为脉宽检测输入信号）
	TMR1IF = 0;      //清中断标志
	TMR1IP = 1;		 //高优先级中断
	TMR1IE = 1;      //使能TMR1中断
	INT2IF = 0;      //清中断标志
	INT2IP = 1;      //高优先级中断
	INT2IE = 1;      //使能外部中断

	PR2H = 0X03;     //500us
	PR2L = 0XE8;
	TMR1H  = 0X00;
	TMR1L  = 0X00;
	T2CON = 0X06;   //使能TMR2 预分频设置为8分频
	
}